
// BIProject.h
// BISubstrate
// 
// Copyright (c) 2001 Marketcircle Inc. All rights reserved.


/*!
    @class       BIProject
    @abstract    BIProject represents a project which the user is working on for a client.
    @discussion  A client can have many projects.  The project is the root to almost all of the major objects.  Projects have estimate slips, estimates, timeslips, invoices, payments, etc.  They are the central object.
*/


#ifdef BILLINGS_PRO
#import "_BPProject.h"
#endif
#ifdef BILLINGS_SINGLE
#import "_BIProject.h"
#endif
#import "BIAppVersioning.h"

@class BIUser;

@interface BIProject : BL_SUPER_CLASSNAME_MUNGE(Project) 
{
}

+ (BIProject*)createTempProject;

- (void)setInitialValues;
- (void)setInitialValuesWithObjectContext:(id)oc;

// This was created for the spotlight importer, which will want an array of strings of all the timeslips to index
- (NSArray *)associatedTimeslipNames;

//- (NSArray*)notInvoicedTimeSlips;

- (NSNumber*)activeTimeSlipsTotal;
- (void)setActiveTimeSlipsTotal:(NSNumber*)aTotal;

- (NSArray*)keysForProjectCard;

- (NSString *)archivableRepresentationName;

// kvo compliance
- (void)setPreferredName:(NSString*)aName;
- (NSString*)preferredName;

- (BOOL)urlReferencesContainsURL:(NSString*)aURL;

- (BOOL)useNicknameBool;
- (void)setUseNicknameBool: (BOOL)flag;

- (BOOL)isCompleteDate;
- (void)setIsCompleteDate:(BOOL)flag;

- (BOOL)isStartDate;
- (void)setIsStartDate:(BOOL)flag;

- (BOOL)isDueDate;
- (void)setIsDueDate:(BOOL)flag;

- (void)removeFromActiveTimeslipsSilently:(BITimeSlip*)object;

// an activeTimerTimeSlip is a time slip which is a Timed Time Slip, is active (in activeTimeSlips) and whose
// activeForTiming attribute is YES
- (NSArray*)activeTimerTimeSlips;
- (BOOL)hasActiveTimerTimeSlips;

- (NSArray*)activeTimerSlips;
- (BOOL)hasActiveTimerSlips;

- (NSArray *)readyToBeBilledTimeSlips;
- (NSArray *)notReadyToBeBilledTimeSlips;

- (void)setStateWrapper:(BIProjectState *)aValue;
- (BIProjectState *)stateWrapper;

- (NSString*)tabDelimitedRepresentation:(NSArray*)fieldDicts;

- (NSString*)escapedName;
- (void)setEscapedName:(NSString*)aName;

- (NSNumber*)estimatedSubtotalPlusMarkupMinusDiscount;
- (NSNumber*)actualSubtotalPlusMarkupMinusDiscount;
- (long)estimatedDurationOfSlips;
- (long)actualDurationOfSlips;
- (long)durationOfSlips;
- (void)invalidateProjectDurationOfSlipsCached;


- (NSNumber *)derivedOverallTotal;
- (NSNumber *)billableActiveTimeslipsTotal;
- (NSNumber *)estimateTotal;
- (NSNumber *)total;
- (NSString *)formattedTotal;
- (NSNumber*)derivedTotal;
- (void)invalidateProjectTotalCached;

- (NSNumber *)estimatePending;
- (NSNumber *)pending;
- (void)invalidateProjectEstimatePendingCached;

- (NSArray*)plistKeys;
- (NSDictionary*)plistRepresentation;
- (void)restoreValuesFromPlist:(NSDictionary*)aDict;

- (NSString*)stateString;
- (NSString*)stageString;

- (NSNumber *)unbilledAmount;
- (void)setUnbilledAmount:(NSNumber*)aUnbilledAmount;
- (void)invalidateProjectUnbilledAmountCached;

- (NSNumber *)incompleteAmount;
- (void)setIncompleteAmount:(NSNumber*)aIncompleteAmount;
- (void)invalidateProjectIncompleteAmountCached;

- (void)updateAmounts;
- (void)updateEstimateAmounts;

- (NSArray *)invoices;

- (BIProject *)projectForProjectListName;
- (BIProject *)projectForProjectListPending;

- (NSNumberFormatter *)currencyFormatter;


#ifdef BILLINGS_PRO
- (BOOL)workingSlipsRequireApproval;
- (BOOL)currentUserIsApprover;

- (NSNumber *)hourlyRateForUser:(BIUser *)aUser;
- (NSNumber *)mileageRateForUser:(BIUser *)aUser;
#endif


@end
